# 项目结构

## 目录结构

```text
┣ 📂public             # 资源文件夹，打包后放到 dist/
┃ ┗ 📂assets
┃ ┃ ┗ 📜logo.png       # 扩展 logo
┣ 📂scripts            # 构建脚本
┣ 📂src
┃ ┣ 📂schema           # storage schema 描述
┃ ┣ 📂scopes
┃ ┃ ┣ 📂background     # background script
┃ ┃ ┣ 📂content        # content script
┃ ┃ ┣ 📂injects        # inject script
┃ ┃ ┃ ┣ 📂index            # index.entry 的模块
┃ ┃ ┃ ┣ 📜externals.ts     # externals 定义
┃ ┃ ┃ ┗ 📜index.entry.tsx  # 入口文件
┃ ┃ ┣ 📂options        # options 页面
┃ ┃ ┗ 📂popup          # popup 页面
┃ ┣ 📂transformers     # 转换器脚本
┃ ┣ 📜const.ts         # 常量（⚠️ 纯 TS 文件）
┃ ┣ 📜global.d.ts      # 全局类型定义
┃ ┣ 📜manifest.ts      # manifest.json 定义
┃ ┗ 📜messageType.ts   # 消息类型定义
┣ 📜vite.config.ts
┗ 📜package.json
```

## 各文件夹职责

### /src/scopes/background/

- 存放 background script 逻辑
- 可调用所有 Chrome API
- 负责处理来自 InjectScript 的消息
- 管理扩展生命周期
- 注册 content scripts 和 inject scripts

### /src/scopes/content/

- 存放 content script 逻辑
- 运行在隔离环境（Isolated World）
- 可调用 Chrome API
- 无法访问页面的 `window` 对象

### /src/scopes/injects/

- 存放 inject script 逻辑
- 运行在页面的 MAIN world
- **⚠️ 无法调用 Chrome API**
- 可以访问和修改页面的 `window` 对象

**入口文件命名规则**：`*.entry.{ts,tsx}`

```text
📦injects
 ┣ 📂index                # index.entry.tsx 的依赖模块
 ┃ ┣ 📜App.tsx
 ┃ ┗ 📜utils.ts
 ┣ 📂main                 # main.entry.ts 的依赖模块
 ┃ ┗ 📜helper.ts
 ┣ 📜externals.ts
 ┣ 📜index.entry.tsx      # ✅ 入口文件
 ┗ 📜main.entry.tsx       # ✅ 入口文件
```

### /src/scopes/options/ 和 /src/scopes/popup/

- 扩展的 options 和 popup 页面
- 可调用 Chrome API

### /src/schema/

- 存放 storage local 的 schema 定义
- 命名建议：`[schemaName].ts`
- 必须导出类型和 schema 对象

```typescript
// user.ts
export type UserSchemaType = { name: string; age: number; }
export const UserSchema: JSONSchemaType<UserSchemaType> = { /* ... */ }
```

### /src/transformers/

- 存放转换器脚本
- 所有 `.js`, `.ts` 文件编译到 `dist/transformers/`

## 核心配置文件

| 文件 | 用途 | 注意事项 |
|------|------|----------|
| `src/const.ts` | 常量定义 | ⚠️ 被 vite.config.ts 引用，必须是纯 TS |
| `src/global.d.ts` | 全局类型定义 | 定义 window 等全局变量类型 |
| `src/manifest.ts` | Manifest 配置 | 扩展的 manifest.json |
| `src/messageType.ts` | 消息类型定义 | 定义所有消息的类型 |

## 编译输出规则

### InjectScript

| 输入 | 输出 |
|------|------|
| `/src/scopes/injects/index.entry.tsx` | `/dist/injects/index.js` |
| `/src/scopes/injects/main.entry.ts` | `/dist/injects/main.js` |

如果引入了样式，还会生成对应的 CSS 文件：
- `index.entry.tsx` → `dist/injects/index.css`

### Transformers

| 输入 | 输出 |
|------|------|
| `/src/transformers/*.ts` | `/dist/transformers/*.js` |
